<?php
/**
 * @author DEFE
 * @link http://defe.me
 */
class UploadPlugin_Action extends Typecho_Widget implements Widget_Interface_Do
{
    private $_file;

    /**
     * 上传并安装插件/主题
     */
    public function upload()
    {
        $this->widget('Widget_User')->pass('administrator');

        // 检查是否有文件上传
        if (!isset($_FILES['pluginzip']) || $_FILES['pluginzip']['error'] != 0) {
            $this->response->throwJson(array('success' => false, 'message' => '文件上传失败'));
        }

        $file = $_FILES['pluginzip'];
        $this->_file = $file['tmp_name'];

        // 验证文件类型
        if (!$this->isZip($this->_file)) {
            $this->response->throwJson(array('success' => false, 'message' => '上传的文件不是有效的ZIP压缩包'));
        }

        // 打开ZIP文件
        $zip = new ZipArchive();
        if ($zip->open($this->_file) !== TRUE) {
            $this->response->throwJson(array('success' => false, 'message' => '无法打开ZIP文件，文件可能已损坏'));
        }

        $pluginDir = defined('__TYPECHO_PLUGIN_DIR__') ? __TYPECHO_PLUGIN_DIR__ : '/usr/plugins';
        $themeDir = defined('__TYPECHO_THEME_DIR__') ? __TYPECHO_THEME_DIR__ : '/usr/themes';

        $path = '';
        $type = '';

        // 检查是否为插件
        $pluginIndex = $zip->locateName('Plugin.php', ZipArchive::FL_NOCASE | ZipArchive::FL_NODIR);
        if ($pluginIndex !== false) {
            // 这是一个插件
            $type = '插件';
            $fileName = $zip->getNameIndex($pluginIndex);
            $pathParts = explode('/', $fileName);

            if (count($pathParts) > 2) {
                $zip->close();
                $this->response->throwJson(array('success' => false, 'message' => '压缩包目录层级过深，无法安装'));
            }

            $contents = $zip->getFromIndex($pluginIndex);
            $pluginInfo = $this->parsePluginInfo($contents);

            if (!$pluginInfo['name']) {
                $zip->close();
                $this->response->throwJson(array('success' => false, 'message' => '无法识别插件信息'));
            }

            if (count($pathParts) == 2) {
                // 有文件夹
                $path = '.' . $pluginDir . '/';
            } else {
                // 单文件插件
                $path = '.' . $pluginDir . '/' . $pluginInfo['name'] . '/';
            }
        } else {
            // 检查是否为主题
            $themeIndex = $zip->locateName('index.php', ZipArchive::FL_NOCASE | ZipArchive::FL_NODIR);
            if ($themeIndex !== false) {
                $type = '主题';
                $fileName = $zip->getNameIndex($themeIndex);
                $pathParts = explode('/', $fileName);

                if (count($pathParts) > 2) {
                    $zip->close();
                    $this->response->throwJson(array('success' => false, 'message' => '压缩包目录层级过深，无法安装'));
                }

                $contents = $zip->getFromIndex($themeIndex);
                if (!$this->isTheme($contents)) {
                    $zip->close();
                    $this->response->throwJson(array('success' => false, 'message' => '无法识别主题信息'));
                }

                if (count($pathParts) == 2) {
                    // 有文件夹
                    $path = '.' . $themeDir . '/';
                } else {
                    // 使用zip文件名作为主题目录名
                    $themeName = pathinfo($file['name'], PATHINFO_FILENAME);
                    $path = '.' . $themeDir . '/' . $themeName . '/';
                }
            }
        }

        if (!$path) {
            $zip->close();
            $this->response->throwJson(array('success' => false, 'message' => '上传的文件不是有效的Typecho插件或主题'));
        }

        // 解压文件
        if (!$zip->extractTo($path)) {
            $zip->close();
            $this->response->throwJson(array('success' => false, 'message' => '解压失败，请检查目录写入权限'));
        }

        $zip->close();
        $this->response->throwJson(array('success' => true, 'message' => $type . '安装成功，请到控制台启用'));
    }

    /**
     * 删除插件
     */
    public function del()
    {
        $this->widget('Widget_User')->pass('administrator');
        $plugName = $this->request->get('name');

        if (!$plugName) {
            $this->widget('Widget_Notice')->set(_t('插件不存在'), NULL, 'error');
            $this->response->goBack();
        }

        $pluginDir = defined('__TYPECHO_PLUGIN_DIR__') ? __TYPECHO_PLUGIN_DIR__ : '/usr/plugins';
        $dir = '.' . $pluginDir;

        if (!is_writable($dir)) {
            $this->widget('Widget_Notice')->set(_t('插件目录没有写权限'), NULL, 'error');
            $this->response->goBack();
        }

        chdir($dir);
        if (is_dir($plugName)) {
            if ($this->delTree($plugName)) {
                $this->widget('Widget_Notice')->set(_t('成功删除插件：'.$plugName), NULL, 'success');
            } else {
                $this->widget('Widget_Notice')->set(_t('插件删除失败'), NULL, 'error');
            }
        } else {
            $file = $plugName . '.php';
            if (@unlink($file)) {
                $this->widget('Widget_Notice')->set(_t('成功删除插件：'.$plugName), NULL, 'success');
            } else {
                $this->widget('Widget_Notice')->set(_t('插件删除失败'), NULL, 'error');
            }
        }

        $this->response->goBack();
    }

    /**
     * 删除主题
     */
    public function delTheme()
    {
        $this->widget('Widget_User')->pass('administrator');
        $themeName = $this->request->get('name');

        if (!$themeName) {
            $this->widget('Widget_Notice')->set(_t('主题不存在'), NULL, 'error');
            $this->response->goBack();
        }

        $themeDir = defined('__TYPECHO_THEME_DIR__') ? __TYPECHO_THEME_DIR__ : '/usr/themes';
        $dir = '.' . $themeDir;

        if (!is_writable($dir)) {
            $this->widget('Widget_Notice')->set(_t('主题目录没有写权限'), NULL, 'error');
            $this->response->goBack();
        }

        chdir($dir);
        if (is_dir($themeName)) {
            if ($this->delTree($themeName)) {
                $this->widget('Widget_Notice')->set(_t('成功删除主题：'.$themeName), NULL, 'success');
            } else {
                $this->widget('Widget_Notice')->set(_t('主题删除失败'), NULL, 'error');
            }
        } else {
            $this->widget('Widget_Notice')->set(_t('主题不存在'), NULL, 'error');
        }

        $this->response->goBack();
    }

    /**
     * 递归删除目录
     */
    private function delTree($dir)
    {
        chdir($dir);
        $dh = opendir('.');
        while (false !== ($file = readdir($dh))) {
            if ($file == '.' || $file == '..') continue;

            if (is_file($file)) {
                if (!@unlink($file)) {
                    closedir($dh);
                    return false;
                }
            } else if (is_dir($file)) {
                if (!$this->delTree('./' . $file)) {
                    closedir($dh);
                    return false;
                }
            }
        }
        closedir($dh);
        chdir('..');
        return @rmdir($dir);
    }

    /**
     * 检查是否为ZIP文件
     */
    private function isZip($file)
    {
        $fp = @fopen($file, "rb");
        if (!$fp) return false;

        $bin = fread($fp, 4);
        fclose($fp);

        $hex = bin2hex($bin);
        return (strtolower($hex) === '504b0304');
    }

    /**
     * 解析插件信息
     */
    private function parsePluginInfo($content)
    {
        $info = array('name' => '', 'title' => '', 'version' => '', 'author' => '');

        $tokens = token_get_all($content);
        $isDoc = false;
        $isClass = false;

        foreach ($tokens as $token) {
            if (!$isDoc && is_array($token) && $token[0] == T_DOC_COMMENT) {
                $lines = preg_split('/\r\n|\r|\n/', $token[1]);
                foreach ($lines as $line) {
                    $line = trim($line, " \t/*");
                    if (preg_match('/@package\s+(.+)/', $line, $matches)) {
                        $info['title'] = trim($matches[1]);
                    } else if (preg_match('/@version\s+(.+)/', $line, $matches)) {
                        $info['version'] = trim($matches[1]);
                    } else if (preg_match('/@author\s+(.+)/', $line, $matches)) {
                        $info['author'] = trim($matches[1]);
                    }
                }
                $isDoc = true;
            }

            if (!$isClass && is_array($token) && $token[0] == T_CLASS) {
                $isClass = true;
            }

            if ($isClass && is_array($token) && $token[0] == T_STRING) {
                $parts = explode('_', $token[1]);
                $info['name'] = $parts[0];
                break;
            }
        }

        return $info;
    }

    /**
     * 检查是否为主题
     */
    private function isTheme($content)
    {
        $tokens = token_get_all($content);
        foreach ($tokens as $token) {
            if (is_array($token) && $token[0] == T_DOC_COMMENT) {
                return (strpos($token[1], '@package') !== false);
            }
        }
        return false;
    }

    public function action()
    {
        $this->widget('Widget_User')->pass('administrator');
        $this->on($this->request->is('do=upload'))->upload();
        $this->on($this->request->is('do=del'))->del();
        $this->on($this->request->is('do=delTheme'))->delTheme();
    }
}
