<?php
include 'header.php';
include 'menu.php';
?>
<div class="main">
    <div class="body container">
        <?php include 'page-title.php'; ?>
        <div class="col-group typecho-page-main">
            <div class="col-mb-12 typecho-list">
                <div class="clearfix">
                    <ul class="typecho-option-tabs">
                        <li <?php if(!isset($request->p)){ ?>class="current"<?php }?>><a href="<?php $options->adminUrl('extending.php?panel=UploadPlugin%2Fpanel.php'); ?>"><?php _e('插件管理'); ?></a></li>
                        <li <?php if(1 == $request->p){ ?>class="current"<?php }?>><a href="<?php $options->adminUrl('extending.php?panel=UploadPlugin%2Fpanel.php&p=1'); ?>"><?php _e('模板管理'); ?></a></li>
                    </ul>
                </div>

                <!-- 上传表单 -->
                <div class="typecho-page-main" style="margin-top: 20px; padding: 20px; background: #f6f6f6; border-radius: 4px;">
                    <h3>上传插件/主题</h3>
                    <form id="upload-form" method="post" enctype="multipart/form-data" style="margin-top: 15px;">
                        <p>
                            <label for="pluginzip">选择ZIP文件：</label>
                            <input type="file" name="pluginzip" id="pluginzip" accept=".zip,application/zip" required />
                        </p>
                        <p>
                            <button type="submit" class="btn primary" id="upload-btn">上传并安装</button>
                            <span id="upload-status" style="margin-left: 10px;"></span>
                        </p>
                        <p style="color: #999; font-size: 12px;">
                            支持上传ZIP格式的插件和主题压缩包，将自动识别类型并安装到对应目录。
                        </p>
                    </form>
                </div>

                <!---插件管理--->
                <?php if(!isset($request->p)): ?>
                <?php Typecho_Widget::widget('Widget_Plugins_List@unactivated', 'activated=0')->to($deactivatedPlugins); ?>

                <h4 class="typecho-list-table-title"><?php _e('可删除的插件'); ?></h4>
                <div class="typecho-table-wrap">
                    <table class="typecho-list-table">
                        <colgroup>
                            <col width="25%"/>
                            <col width="45%"/>
                            <col width="8%"/>
                            <col width="10%"/>
                            <col width=""/>
                        </colgroup>
                        <thead>
                            <tr>
                                <th><?php _e('名称'); ?></th>
                                <th><?php _e('描述'); ?></th>
                                <th><?php _e('版本'); ?></th>
                                <th><?php _e('作者'); ?></th>
                                <th class="typecho-radius-topright"><?php _e('操作'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($deactivatedPlugins->have()): ?>
                            <?php while ($deactivatedPlugins->next()): ?>
                            <tr id="plugin-<?php $deactivatedPlugins->name(); ?>">
                                <td><?php $deactivatedPlugins->title(); ?></td>
                                <td><?php $deactivatedPlugins->description(); ?></td>
                                <td><?php $deactivatedPlugins->version(); ?></td>
                                <td><?php echo empty($deactivatedPlugins->homepage) ? $deactivatedPlugins->author : '<a href="' . $deactivatedPlugins->homepage . '">' . $deactivatedPlugins->author . '</a>'; ?></td>
                                <td><a lang="<?php _e('你确认要删除 %s 插件吗?', $deactivatedPlugins->name); ?>" href="<?php $options->index('/action/upload-plugin?do=del&name=' . $deactivatedPlugins->name); ?>" class="operate-delete"><?php _e('删除'); ?></a></td>
                            </tr>
                            <?php endwhile; ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="5"><h6 class="typecho-list-table-title"><?php _e('没有可以删除的插件'); ?></h6></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php Typecho_Widget::widget('Widget_Plugins_List@activated', 'activated=1')->to($activatedPlugins); ?>
                <?php if ($activatedPlugins->have() || !empty($activatedPlugins->activatedPlugins)): ?>
                <h4 class="typecho-list-table-title"><?php _e('启用的插件'); ?></h4>
                <div class="typecho-table-wrap">
                    <table class="typecho-list-table deactivate">
                        <colgroup>
                            <col width="25%"/>
                            <col width="45%"/>
                            <col width="8%"/>
                            <col width="10%"/>
                            <col width=""/>
                        </colgroup>
                        <thead>
                            <tr>
                                <th><?php _e('名称'); ?></th>
                                <th><?php _e('描述'); ?></th>
                                <th><?php _e('版本'); ?></th>
                                <th><?php _e('作者'); ?></th>
                                <th><?php _e('操作'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($activatedPlugins->next()): ?>
                            <tr id="plugin-<?php $activatedPlugins->name(); ?>">
                                <td><?php $activatedPlugins->title(); ?></td>
                                <td><?php $activatedPlugins->description(); ?></td>
                                <td><?php $activatedPlugins->version(); ?></td>
                                <td><?php echo empty($activatedPlugins->homepage) ? $activatedPlugins->author : '<a href="' . $activatedPlugins->homepage . '">' . $activatedPlugins->author . '</a>'; ?></td>
                                <td>
                                    <?php if ($activatedPlugins->activated): ?>
                                        <a lang="<?php _e('你确认要禁用插件 %s 吗?', $activatedPlugins->name); ?>" href="<?php $options->index('/action/plugins-edit?deactivate=' . $activatedPlugins->name); ?>"><?php _e('禁用'); ?></a>
                                    <?php else: ?>
                                        <a href="<?php $options->index('/action/plugins-edit?activate=' . $activatedPlugins->name); ?>"><?php _e('启用'); ?></a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>

                <?php else: ?>
                <h4 class="typecho-list-table-title"><?php _e('可删除的模板'); ?></h4>
                <div class="typecho-table-wrap">
                    <table class="typecho-list-table">
                        <colgroup>
                            <col width="15%"/>
                            <col width="50%"/>
                            <col width="8%"/>
                            <col width="15%"/>
                            <col width=""/>
                        </colgroup>
                        <thead>
                            <tr>
                                <th><?php _e('名称'); ?></th>
                                <th><?php _e('描述'); ?></th>
                                <th><?php _e('版本'); ?></th>
                                <th><?php _e('作者'); ?></th>
                                <th class="typecho-radius-topright"><?php _e('操作'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php Typecho_Widget::widget('Widget_Themes_List')->to($themes); ?>
                            <?php if( $themes->length >= 2 ):?>
                            <?php while($themes->next()): ?>
                            <?php if($themes->activated) continue; ?>
                                <tr id="theme-<?php $themes->name(); ?>">
                                    <td><?php $themes->name(); ?></td>
                                    <td><?php echo nl2br($themes->description); ?></td>
                                    <td><?php $themes->version(); ?></td>
                                    <td><?php echo empty($themes->homepage) ? $themes->author : '<a href="' . $themes->homepage . '">' . $themes->author . '</a>'; ?></td>
                                    <td><a lang="<?php _e('你确认要删除 %s 模板吗?', $themes->name); ?>" class="operate-delete" href="<?php $options->index('/action/upload-plugin?do=delTheme&name=' . $themes->name); ?>"><?php _e('删除'); ?></a></td>
                                </tr>
                            <?php endwhile; ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="5"><h6 class="typecho-list-table-title"><?php _e('没有可以删除的模板'); ?></h6></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
(function() {
    var form = document.getElementById('upload-form');
    var btn = document.getElementById('upload-btn');
    var status = document.getElementById('upload-status');
    var fileInput = document.getElementById('pluginzip');

    form.addEventListener('submit', function(e) {
        e.preventDefault();

        if (!fileInput.files || !fileInput.files[0]) {
            alert('请选择要上传的文件');
            return;
        }

        var file = fileInput.files[0];
        if (!file.name.toLowerCase().endsWith('.zip')) {
            alert('只支持ZIP格式的文件');
            return;
        }

        var formData = new FormData();
        formData.append('pluginzip', file);

        btn.disabled = true;
        status.innerHTML = '<span style="color: #467b96;">上传中...</span>';

        var xhr = new XMLHttpRequest();
        xhr.open('POST', '<?php $options->index('/action/upload-plugin?do=upload'); ?>', true);

        xhr.onload = function() {
            if (xhr.status === 200) {
                try {
                    var response = JSON.parse(xhr.responseText);
                    if (response.success) {
                        status.innerHTML = '<span style="color: #0a0;">' + response.message + '</span>';
                        setTimeout(function() {
                            window.location.reload();
                        }, 1500);
                    } else {
                        status.innerHTML = '<span style="color: #c33;">' + response.message + '</span>';
                        btn.disabled = false;
                    }
                } catch(e) {
                    status.innerHTML = '<span style="color: #c33;">上传失败：服务器响应错误</span>';
                    btn.disabled = false;
                }
            } else {
                status.innerHTML = '<span style="color: #c33;">上传失败：HTTP ' + xhr.status + '</span>';
                btn.disabled = false;
            }
        };

        xhr.onerror = function() {
            status.innerHTML = '<span style="color: #c33;">上传失败：网络错误</span>';
            btn.disabled = false;
        };

        xhr.send(formData);
    });

    // 删除确认
    var deleteLinks = document.querySelectorAll('.operate-delete');
    for (var i = 0; i < deleteLinks.length; i++) {
        deleteLinks[i].addEventListener('click', function(e) {
            if (!confirm(this.getAttribute('lang'))) {
                e.preventDefault();
                return false;
            }
        });
    }
})();
</script>

<?php
include 'copyright.php';
include 'common-js.php';
include 'footer.php';
?>
