# AIHelper - Typecho AI助手插件

Typecho AI助手插件，使用AI自动生成文章的Slug、摘要和标签。

## 功能特性

1. **自动生成Slug**
   - 在文章编辑页面输入标题时，自动调用AI将中文标题翻译为符合英文语法的slug
   - 使用连字符(-)连接单词
   - 可手动点击"AI生成Slug"按钮重新生成

2. **自动生成摘要**
   - 在提交文章时自动生成摘要
   - 摘要保存在自定义字段`summary`中
   - 如果已有summary字段，则不会重复生成（避免覆盖）

3. **自动提取标签**
   - 在提交文章时自动提取1-5个相关标签
   - 自动创建新标签并关联到文章

4. **批量生成摘要**
   - 在文章管理页面提供批量操作功能
   - 可勾选多篇文章批量生成摘要
   - 批量生成会覆盖已有的summary字段

## 安装方法

1. 将`AIHelper`文件夹上传到`usr/plugins/`目录
2. 登录Typecho后台，进入"控制台" -> "插件"
3. 找到"AIHelper"插件，点击"启用"
4. 点击"设置"按钮，配置AI API参数

## 配置说明

插件需要配置以下参数：

### API地址
填写兼容OpenAI格式的API地址，例如：
- DeepSeek: `https://api.deepseek.com`
- OpenAI: `https://api.openai.com`
- 其他兼容OpenAI格式的API服务

### API密钥
填写您的API密钥

### 模型名称
填写模型名称，例如：
- DeepSeek: `deepseek-chat`
- OpenAI: `gpt-3.5-turbo`, `gpt-4`
- 其他模型按实际情况填写

### 提示词配置

**Slug生成提示词**（默认）：
```
请将以下中文标题翻译成符合英文语法的简短slug，使用连字符(-)连接单词，只返回slug本身，不要有其他内容。标题：{title}
```

**摘要生成提示词**（默认）：
```
请为以下文章生成一个简洁的摘要(150字以内)：

{content}
```

**标签提取提示词**（默认）：
```
请为以下文章提取1-5个最相关的标签，直接返回标签，用逗号分隔，不要有其他内容：

{content}
```

> 注意：提示词中的`{title}`和`{content}`是占位符，会被实际内容替换，请勿删除。

## 使用说明

### 自动生成Slug

1. 在文章编辑页面输入标题
2. 等待1秒后会自动调用AI生成slug并填入slug字段
3. 也可以手动点击slug输入框旁边的"AI生成Slug"按钮

### 自动生成摘要和标签

1. 编写文章内容
2. 点击"发布文章"或"保存草稿"
3. 插件会自动生成摘要和标签
4. 摘要保存在自定义字段`summary`中
5. 标签会自动创建并关联到文章

### 获取摘要

在主题模板中可以这样获取摘要：

```php
<?php
// 获取自定义字段summary
$summary = $this->fields->summary;
if ($summary) {
    echo $summary;
} else {
    // 如果没有summary字段，使用默认摘要
    $this->excerpt(150, '...');
}
?>
```

### 批量生成摘要

1. 进入"管理" -> "文章"页面
2. 勾选需要生成摘要的文章
3. 在"选择操作"下拉菜单中选择"批量生成摘要"
4. 点击"应用"按钮
5. 确认操作后等待生成完成

> 注意：批量生成会覆盖已有的summary字段。

## 注意事项

1. 需要PHP支持cURL扩展
2. 服务器需要能够访问配置的API地址
3. API调用需要消耗额度，请合理使用
4. 首次发布文章时会生成摘要和标签，后续修改文章不会重复生成（除非删除summary字段）
5. 批量生成摘要会覆盖已有的summary字段，请谨慎操作

## 常见问题

**Q: Slug没有自动生成？**
A: 请检查：
1. 插件是否已启用并配置API参数
2. 浏览器控制台是否有错误信息
3. API密钥是否正确
4. 服务器是否能够访问API地址

**Q: 摘要没有自动生成？**
A: 请检查：
1. 文章是否有内容
2. 是否已有summary字段（如有则不会重复生成）
3. API是否调用成功（可查看服务器日志）

**Q: 如何自定义提示词？**
A: 在插件设置页面可以自定义提示词，但请保留`{title}`和`{content}`占位符。

**Q: 支持哪些AI服务？**
A: 支持所有兼容OpenAI格式的API服务，包括DeepSeek、OpenAI、Azure OpenAI等。

## 版本信息

- 版本: 1.0.0
- 适用于: Typecho 1.2+
- 许可证: MIT

## 技术支持

如有问题或建议，欢迎提交Issue。
