<?php
/**
 * AIHelper AJAX处理文件
 */

// 加载Typecho
if (!defined('__TYPECHO_ROOT_DIR__')) {
   // $rootDir = dirname(dirname(dirname(__DIR__)));
   // if (file_exists($rootDir . '/config.inc.php')) {
   //     define('__TYPECHO_ROOT_DIR__', $rootDir);
   //     require_once __TYPECHO_ROOT_DIR__ . '/config.inc.php';
   // } else {
        // 尝试其他路径
    //    $rootDir = dirname(dirname(dirname(dirname(__FILE__))));
   //     if (file_exists($rootDir . '/config.inc.php')) {
      //      define('__TYPECHO_ROOT_DIR__', $rootDir);
    //        require_once __TYPECHO_ROOT_DIR__ . '/config.inc.php';
     //   } else {
    //        die(json_encode(['success' => false, 'message' => '无法找到Typecho根目录']));
     //   }
   // }
}

use Typecho\Db;
use Widget\Options;

header('Content-Type: application/json; charset=utf-8');

// 检查是否登录
try {
    \Widget\User::alloc()->pass('administrator');
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => '未登录或无权限'
    ]);
    exit;
}

try {
    $action = isset($_POST['action']) ? $_POST['action'] : '';

    switch ($action) {
        case 'generate_slug':
            if (empty($_POST['title'])) {
                throw new Exception('标题不能为空');
            }

            $slug = TypechoPlugin\AIHelper\Plugin::generateSlug($_POST['title']);

            if ($slug) {
                echo json_encode(['success' => true, 'slug' => $slug]);
            } else {
                throw new Exception('生成Slug失败');
            }
            break;

        case 'batch_generate_summary':
            if (empty($_POST['cids'])) {
                throw new Exception('请选择文章');
            }

            $cids = explode(',', $_POST['cids']);
            $db = Db::get();

            $successCount = 0;
            $failCount = 0;

            foreach ($cids as $cid) {
                $cid = intval($cid);

                try {
                    // 获取文章内容
                    $post = $db->fetchRow($db->select('text')->from('table.contents')
                        ->where('cid = ?', $cid));

                    if (!$post) {
                        $failCount++;
                        continue;
                    }

                    // 生成摘要
                    $summary = TypechoPlugin\AIHelper\Plugin::generateSummary($post['text']);

                    if (!$summary) {
                        $failCount++;
                        continue;
                    }

                    // 删除旧的summary字段
                    $db->query($db->delete('table.fields')
                        ->where('cid = ?', $cid)
                        ->where('name = ?', 'summary'));

                    // 插入新的summary字段
                    $db->query($db->insert('table.fields')->rows([
                        'cid' => $cid,
                        'name' => 'summary',
                        'type' => 'str',
                        'str_value' => $summary,
                        'int_value' => 0,
                        'float_value' => 0
                    ]));

                    $successCount++;
                } catch (Exception $e) {
                    $failCount++;
                }
            }

            echo json_encode([
                'success' => true,
                'message' => "成功生成 {$successCount} 篇，失败 {$failCount} 篇"
            ]);
            break;

        case 'generate_article':
            if (empty($_POST['title'])) {
                throw new Exception('标题不能为空');
            }

            $article = TypechoPlugin\AIHelper\Plugin::generateArticle($_POST['title']);

            if ($article) {
                echo json_encode([
                    'success' => true,
                    'content' => $article
                ]);
            } else {
                throw new Exception('生成文章失败，请检查API配置');
            }
            break;

        default:
            throw new Exception('未知操作');
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
