(function($) {
    'use strict';

    // 确保jQuery已加载
    if (typeof $ === 'undefined') {
        console.error('jQuery未加载');
        return;
    }

    $(document).ready(function() {
        // 在批量操作下拉菜单中添加"批量生成摘要"选项
        var actionSelect = $('select[name="action"]');

        if (!actionSelect.length) {
            return;
        }

        // 检查是否已添加选项
        if (actionSelect.find('option[value="aihelper_batch_summary"]').length === 0) {
            actionSelect.append('<option value="aihelper_batch_summary">批量生成摘要</option>');
        }

        // 获取原始的批量操作表单
        var batchForm = actionSelect.closest('form');
        var originalAction = batchForm.attr('action');
        var isProcessing = false;

        // 拦截表单提交
        batchForm.on('submit', function(e) {
            var selectedAction = actionSelect.val();

            if (selectedAction === 'aihelper_batch_summary') {
                e.preventDefault();

                if (isProcessing) {
                    return false;
                }

                // 获取选中的文章ID
                var selectedCids = [];
                $('input[name="cid[]"]:checked').each(function() {
                    selectedCids.push($(this).val());
                });

                if (selectedCids.length === 0) {
                    alert('请至少选择一篇文章');
                    return false;
                }

                if (!confirm('确定要为选中的 ' + selectedCids.length + ' 篇文章批量生成摘要吗？\n这将覆盖已有的摘要字段。')) {
                    return false;
                }

                isProcessing = true;

                // 显示处理中状态
                var submitBtn = batchForm.find('button[type="submit"]');
                var originalBtnText = submitBtn.text();
                submitBtn.text('处理中...').prop('disabled', true);

                // 获取插件URL
                var pluginUrl = '';
                $('script').each(function() {
                    var src = $(this).attr('src');
                    if (src && src.indexOf('/usr/plugins/AIHelper/') !== -1) {
                        pluginUrl = src.substring(0, src.lastIndexOf('/'));
                        return false;
                    }
                });

                // 发送AJAX请求
                $.ajax({
                    url: pluginUrl.replace('/static', '') + '/action.php',
                    type: 'POST',
                    data: {
                        action: 'batch_generate_summary',
                        cids: selectedCids.join(',')
                    },
                    dataType: 'json',
                    timeout: 120000, // 2分钟超时
                    success: function(response) {
                        if (response.success) {
                            alert(response.message || '批量生成摘要成功！');
                            // 刷新页面
                            window.location.reload();
                        } else {
                            alert('批量生成摘要失败：' + (response.message || '未知错误'));
                        }
                    },
                    error: function(xhr, status, error) {
                        alert('批量生成摘要请求失败：' + error);
                    },
                    complete: function() {
                        isProcessing = false;
                        submitBtn.text(originalBtnText).prop('disabled', false);
                    }
                });

                return false;
            }
        });
    });

})(jQuery);
